Option Explicit
Global Base_Error As String  'Holds an error message if the last
                             'operation was not successful.



'BASES.BAS Version 2.05. April 1997. Ian Howlett.
'----------------------------------------------------

'FOR IN-DEPTH HELP ON THIS CODE MODULE, PLEASE SEE THE HELP FILE
'BASES.HLP


'This code and all it's associated files is shareware.
'Please consider registering it for just $5. Please see the
'help file BASES.HLP for information, or e-mail the author on the
'address shown below.



'This BAS file is used for converting numbers between one base and another.
'Bases 2-36 are handled, using digits 0-9 and then A-Z to give the 36
'"digits" needed.

'The functions will now handle numbers with a point (real numbers).
'They will not handle negative numbers, since the different methods
'used in different systems to represent negative numbers may lead to
'errors determining whether a number is negative or positive.


'There are four main functions which the programmer should use:

'DecimalToBase converts a decimal to another base.
'BaseToDecimal converts a number stored in another base to decimal (base 10).
'CorrectBase checks that a number could be legally stored in a
'   specified base number.
'RoundBase rounds a number stored in a non-decimal base to a specified
'   number of places.

'There are other functions which are used internally, and the programmer
'does not need to access these.

'Any error returned will be stored in the global variable Base_Error and
'the function will not return any value.
'If Base_Error = "" then no error has occurred.





'Usage Guide
'------------

'To convert 95 in base 10 (decimal) to base 8 (octal), use
'    DecimalToBase(95,8)


'To convert 137 in base 8 (octal) to base 10 (decimal), use
'    BaseToDecimal("137",8)
'    (Remember the "" signs)


'To convert a number in a non-decimal base to another non-decimal base,
'for example 42 in base 2 (binary) is 101010, but 2A in base 16 (hex):
'    DecimalToBase(BaseToDecimal("101010",2),16)

'To round a number stored in a base,:
'RoundNumber ("101010.011",2,1)
'The example here would round 101010.011 stored in base 2 to 1 place.
'(giving 101010.1).



'Bugs, errors and improvements
'-----------------------------

'If you find a bug, get an error, need help using the functions or can
'suggest any improvements, please contact me via e-mail
'using the address shown at the bottom of this section.

'If you get an error, first ensure that every parameter passed and the
'result of of the correct data type. e.g. Strings where strings should
'be passed, numbers where numbers should be passed, etc.

'The functions don't like numbers being passed using exponents, for example
'3.215E+16. This should not be a problem, since the function FullNumber
'converts these to full numbers.

'The level of accuracy that Visual BASIC uses to store numbers
'governs the accuracy of the functions. There are separate functions called
'automatically to handle integers and numbers with a point. Integers can be
'accurately handled to a much higher range (at least 999,999,999,999,999)
'that numbers with a point.



'Version Information
'-------------------

'These functions were written using Visual BASIC 3 for Windows 3.11.
'However, there are no special version-specific commands, so any
'version of Visual BASIC should be alright.



'Legal Information
'-----------------

                             'COPYRIGHT NOTICE

'THE COPYRIGHT FOR THIS PROGRAM BELONGS ENTIRELY AND EXCLUSIVELY TO THE
'AUTHOR, IAN HOWLETT. THE PROGRAM AND/OR ONE OR MORE OF IT'S ASSOCIATED
'FILES MAY NOT BE DECOMPILED, REVERSE ENGINEERED OR ALTERED IN ANY WAY
'WHATSOEVER - TO DO SO IS AN INFRINGEMENT OF THE COPYRIGHT. ONLY THE
'ORIGINAL COMPRESSED FILE OF AN UNREGISTERED PIECE OF SHAREWARE MAY BE
'COPIED FREELY. THE WHOLE OR ANY PART OF A REGISTERED PIECE OF SHAREWARE
'MAY NOT BE COPIED AND/OR SOLD UNDER ANY CIRCUMSTANCES. REGISTRATION NAMES,
'KEYS AND/OR ASSOCIATED INFORMATION ARE ALSO STRICTLY PRIVATE AND MUST NOT
'BE SHARED, DIVULGED OR TRANSFERRED.
                      

                      'LIMITED WARRANTY AND DISCLAIMER

'THE AUTHOR, IAN HOWLETT, HEREBY DISCLAIMS ALL OTHER WARRANTIES RELATING TO
'THIS SOFTWARE, WHETHER EXPRESS, IMPLIED, STATUTORY OR IN ANY COMMUNICATION
'WITH YOU, AND SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF MERCHANTABILITY
'OR FITNESS FOR A PARTICULAR PURPOSE OR USE. THE AUTHOR DOES NOT WARRANT
'THAT THE OPERATION OF THIS SOFTWARE WILL BE UNINTERRUPTED OR ERROR-FREE.

                         
                         'LIMITATION OF LIABILITY
'
'IN NO EVENT WILL THE AUTHOR BE LIABLE FOR ANY DAMAGES, INCLUDING BUT
'NOT LIMITED TO LOSS OF DATA, LOST PROFITS, COST OF COVER OR OTHER SPECIAL,
'INCIDENTAL, CONSEQUENTIAL OR INDIRECT DAMAGES ARISING FROM THE USE OR
'ATTEMPTED USE OF THIS SOFTWARE OR ACCOMPANYING DOCUMENTATION, HOWEVER
'CAUSED AND ON ANY THEORY OF LIABILITY.
'
'THIS LIMITATION WILL APPLY EVEN IF THE AUTHOR HAS BEEN ADVISED OF
'THE POSSIBILITY OF SUCH DAMAGE. UNDER NO CIRCUMSTANCES SHALL THE LIABILITY
'OF THE AUTHOR EXCEED THE ACTUAL AMOUNT PAID TO AND RECEIVED IN CONNECTION
'WITH THE PARTICULAR COPY OF THE SOFTWARE IN QUESTION.




'Contacting the Author
'---------------------

'These functions were written by:

'Ian Howlett.

'CompuServe: 101720,3025
'Internet:   igh@compuserve.com
'Web:        http://ourworld.compuserve.com/homepages/igh

'The latest updates to this software and other titles from the same author
'will always be available on the web site shown above.

Function BaseToDecimal (NumberStr As String, BaseNo As Integer)

'Converts a positive number in any base from 2 to 36 into a decimal
'(base 10) number.
'
'Handles integers and real numbers (those with a point).
'Does NOT deal with negative numbers (smaller than 0).
'
'
'SYNTAX for use:
'
'DecimalToBase (NumberStr, BaseNo)
'
'Where: NumberStr is a string holding the number to convert.
'           If you are giving a value rather than referring to a
'           string-type variable, enclose the value in "".
'       BaseNo is an integer from 2 to 36, holding the base the number
'           stored in NumberStr is held in.

'       The result of the function is returned as type variant.


NumberStr = FullNumber(NumberStr)

If InStr(NumberStr, ".") = 0 Then
    BaseToDecimal = BaseToDecimal_NoPoint(NumberStr, BaseNo)
Else
    BaseToDecimal = BaseToDecimal_Point(NumberStr, BaseNo)
End If


End Function

Function BaseToDecimal_NoPoint (NumberStr As String, BaseNo As Integer)

'This function is designed not to be used by
'the programmer, only internally by the functions.

'It handles converting integers stored in a non-decimal base into decimal.
'It provides a higher level of accuracy for integers than it's
'associated function BaseToDecimal_Point.

'Although this function can be called directly by the programmer,
'calling the function BaseToDecimal instead will automatically
'decide which of the two functions is the most efficient for the
'number that has been passed as a parameter.

'The syntax for this function is the same as for BaseToDecimal.


On Error GoTo BaseToDecimal_NoPoint_Error

Static BaseChars(0 To 35) As String
Dim c1, c2, temp  As Integer
Dim Result, AmountLeft As Double

Erase BaseChars

'Define Base characters
BaseChars(0) = "0"
BaseChars(1) = "1"
BaseChars(2) = "2"
BaseChars(3) = "3"
BaseChars(4) = "4"
BaseChars(5) = "5"
BaseChars(6) = "6"
BaseChars(7) = "7"
BaseChars(8) = "8"
BaseChars(9) = "9"
BaseChars(10) = "A"
BaseChars(11) = "B"
BaseChars(12) = "C"
BaseChars(13) = "D"
BaseChars(14) = "E"
BaseChars(15) = "F"
BaseChars(16) = "G"
BaseChars(17) = "H"
BaseChars(18) = "I"
BaseChars(19) = "J"
BaseChars(20) = "K"
BaseChars(21) = "L"
BaseChars(22) = "M"
BaseChars(23) = "N"
BaseChars(24) = "O"
BaseChars(25) = "P"
BaseChars(26) = "Q"
BaseChars(27) = "R"
BaseChars(28) = "S"
BaseChars(29) = "T"
BaseChars(30) = "U"
BaseChars(31) = "V"
BaseChars(32) = "W"
BaseChars(33) = "X"
BaseChars(34) = "Y"
BaseChars(35) = "Z"


'Check base is within range
If BaseNo < 2 Or BaseNo > 36 Then
    Base_Error = "The base is out of range 2-36."
    Exit Function
End If

'Check the number is stored in the correct base
If Not CorrectBase(NumberStr, BaseNo) Then
    Base_Error = "The number is not stored in the correct base."
    Exit Function
End If

'Work through Number from left to right

Result = 0
For c1 = 1 To Len(NumberStr)
    'find what the character represents
    For c2 = 0 To 36
        If Mid$(NumberStr, c1, 1) = BaseChars(c2) Then
            temp = c2
            Exit For
        End If
    Next c2
    Result = Result + temp * (BaseNo ^ (Len(NumberStr) - c1))
Next c1

BaseToDecimal_NoPoint = Result
Base_Error = ""

Exit Function      'should exit here


BaseToDecimal_NoPoint_Error:
Base_Error = Error$(Err)
Exit Function
Resume

End Function

Function BaseToDecimal_Point (NumberStr As String, BaseNo As Integer)

'This function is designed not to be used by
'the programmer, only internally by the functions.

'It handles converting numbers with a point stored in a non-decimal
'base into decimal.
'It does not give as high a level of accuracy for large numbers as
'BaseToDecimal_NoPoint, but supports real numbers as opposed to integers.

'Although this function can be called directly by the programmer,
'calling the function BaseToDecimal instead will automatically
'decide which of the two functions is the most efficient for the
'number that has been passed as a parameter.

'The syntax for this function is the same as for BaseToDecimal.


On Error GoTo BaseToDecimal_Point_Error

Static BaseChars(0 To 35) As String
Dim count1, count2, temp, Power As Integer
Dim Result, AmountLeft As Double

Erase BaseChars

'Define Base characters
BaseChars(0) = "0"
BaseChars(1) = "1"
BaseChars(2) = "2"
BaseChars(3) = "3"
BaseChars(4) = "4"
BaseChars(5) = "5"
BaseChars(6) = "6"
BaseChars(7) = "7"
BaseChars(8) = "8"
BaseChars(9) = "9"
BaseChars(10) = "A"
BaseChars(11) = "B"
BaseChars(12) = "C"
BaseChars(13) = "D"
BaseChars(14) = "E"
BaseChars(15) = "F"
BaseChars(16) = "G"
BaseChars(17) = "H"
BaseChars(18) = "I"
BaseChars(19) = "J"
BaseChars(20) = "K"
BaseChars(21) = "L"
BaseChars(22) = "M"
BaseChars(23) = "N"
BaseChars(24) = "O"
BaseChars(25) = "P"
BaseChars(26) = "Q"
BaseChars(27) = "R"
BaseChars(28) = "S"
BaseChars(29) = "T"
BaseChars(30) = "U"
BaseChars(31) = "V"
BaseChars(32) = "W"
BaseChars(33) = "X"
BaseChars(34) = "Y"
BaseChars(35) = "Z"


'Check base is within range
If BaseNo < 2 Or BaseNo > 36 Then
    Base_Error = "The base is out of range 2-36."
    Exit Function
End If

'Check the number is stored in the correct base
If Not CorrectBase(NumberStr, BaseNo) Then
    Base_Error = "The number is not stored in the correct base."
    Exit Function
End If

'Work through Number from left to right

    'Find the power of the number in the furthest left column
    If InStr(NumberStr, ".") <> 0 Then
        Power = InStr(NumberStr, ".") - 2
    Else
        Power = Len(NumberStr) - 1
    End If
    '
    
Result = 0
For count1 = 1 To Len(NumberStr)
    If Mid$(NumberStr, count1, 1) <> "." Then
        'find what the character represents
        For count2 = 0 To 36
            If Mid$(NumberStr, count1, 1) = BaseChars(count2) Then
                temp = count2
                Exit For
            End If
        Next count2
        Result = Result + (temp * (BaseNo ^ Power))
        Power = Power - 1
    End If
Next count1


BaseToDecimal_Point = Result
Base_Error = ""
'
Exit Function  'Should exit here


BaseToDecimal_Point_Error:
Base_Error = Error$(Err)
Exit Function
Resume

End Function

Function CorrectBase (NumberStr As String, BaseNo As Integer) As Integer

'This function is used to check that a number is stored
'in the base passed as parameter BaseNo.

'To do this, it checks there are no invalid characters
'in the number. These include negative signs -

'It is important to note that if this function returns true (see below),
'the number passed as a parameter only *could* be stored legally in
'the base passed. It does not mean that the number actually was stored in
'that base. For example, the number "127" could be stored in base 8
'(octal) or in base 16 (hexadecimal). This function would return true in
'each case. It could not be stored in base 2 (binary), however, since
'the digits 2 and 7 are not supported in that base, so the function would
'return false.



'SYNTAX for use:
'
'CorrectBase (NumberStr, BaseNo)
'
'Where: NumberStr is a string holding the number to check.
'           If you are giving a value rather than referring to a
'           string-type variable, enclose the value in "".
'       BaseNo is an integer from 2 to 36, holding the base the number
'           stored in NumberStr is held in.

'       The result of the function is returned as an integer holding a
'       Boolean value (true or false). If the number does not contain
'       any invalid characters, the function returns true, otherwise it
'       returns false.


Static BaseChars(0 To 35) As String
Dim count1, count2, temp As Integer

Erase BaseChars

'Define Base characters
BaseChars(0) = "0"
BaseChars(1) = "1"
BaseChars(2) = "2"
BaseChars(3) = "3"
BaseChars(4) = "4"
BaseChars(5) = "5"
BaseChars(6) = "6"
BaseChars(7) = "7"
BaseChars(8) = "8"
BaseChars(9) = "9"
BaseChars(10) = "A"
BaseChars(11) = "B"
BaseChars(12) = "C"
BaseChars(13) = "D"
BaseChars(14) = "E"
BaseChars(15) = "F"
BaseChars(16) = "G"
BaseChars(17) = "H"
BaseChars(18) = "I"
BaseChars(19) = "J"
BaseChars(20) = "K"
BaseChars(21) = "L"
BaseChars(22) = "M"
BaseChars(23) = "N"
BaseChars(24) = "O"
BaseChars(25) = "P"
BaseChars(26) = "Q"
BaseChars(27) = "R"
BaseChars(28) = "S"
BaseChars(29) = "T"
BaseChars(30) = "U"
BaseChars(31) = "V"
BaseChars(32) = "W"
BaseChars(33) = "X"
BaseChars(34) = "Y"
BaseChars(35) = "Z"

'Check base is within range
If BaseNo < 2 Or BaseNo > 36 Then
    Base_Error = "The base is out of range 2-36."
    Exit Function
End If

'Uses Temp as a flag to show that a character has been found
For count1 = 1 To Len(NumberStr)
    temp = False
    For count2 = 0 To (BaseNo - 1)
        If Mid$(NumberStr, count1, 1) = BaseChars(count2) Then
            temp = True
            Exit For
        End If
    Next count2
If (Not temp) And (Mid$(NumberStr, count1, 1) <> ".") Then
    CorrectBase = False
    Exit Function
End If
Next count1

'Check there is only one decimal point

count2 = 0
For count1 = 1 To Len(NumberStr)
    If Mid$(NumberStr, count1, 1) = "." Then count2 = count2 + 1
Next count1

If count2 > 1 Then
    CorrectBase = False
    Exit Function
End If


CorrectBase = True
Base_Error = ""
Exit Function


End Function

Function DecimalToBase (number As Double, BaseNo As Integer) As String

'Converts a positive number stored in base 10 (decimal)
'number to a non-decimal base (2-36).
'
'Handles integers and real numbers (those with a point).
'Does NOT deal with negative numbers (smaller than 0).
'
'
'SYNTAX for use:
'
'BaseToDecimal (Number, BaseNo)
'
'Where: Number is a number of type double holding the number to convert.
'       BaseNo is an integer from 2 to 36, holding the base the number
'           stored in NumberStr is held in.

'       The result of the function is returned as a string.


number = FullNumber(number)

If number = Int(number) Then
    DecimalToBase = DecimalToBase_NoPoint(number, BaseNo)
Else
    DecimalToBase = DecimalToBase_Point(number, BaseNo)
End If


End Function

Function DecimalToBase_NoPoint (number As Double, BaseNo As Integer) As String

'This function is designed not to be used by
'the programmer, only internally by the functions.

'It handles converting numbers stored in decimal to a non-decimal base.
'It provides a higher level of accuracy for integers than it's
'associated function DecimalToBase_Point.

'Although this function can be called directly by the programmer,
'calling the function DecimalToBase instead will automatically
'decide which of the two functions is the most efficient for the
'number that has been passed as a parameter.

'The syntax for this function is the same as for DecimalToBase.


On Error GoTo DecimalToBase_NoPoint_Error

Static BaseChars(0 To 35) As String
Dim AmountLeft, Power, c1, temp As Integer
Dim Result As String

Erase BaseChars

'Define Base characters
BaseChars(0) = "0"
BaseChars(1) = "1"
BaseChars(2) = "2"
BaseChars(3) = "3"
BaseChars(4) = "4"
BaseChars(5) = "5"
BaseChars(6) = "6"
BaseChars(7) = "7"
BaseChars(8) = "8"
BaseChars(9) = "9"
BaseChars(10) = "A"
BaseChars(11) = "B"
BaseChars(12) = "C"
BaseChars(13) = "D"
BaseChars(14) = "E"
BaseChars(15) = "F"
BaseChars(16) = "G"
BaseChars(17) = "H"
BaseChars(18) = "I"
BaseChars(19) = "J"
BaseChars(20) = "K"
BaseChars(21) = "L"
BaseChars(22) = "M"
BaseChars(23) = "N"
BaseChars(24) = "O"
BaseChars(25) = "P"
BaseChars(26) = "Q"
BaseChars(27) = "R"
BaseChars(28) = "S"
BaseChars(29) = "T"
BaseChars(30) = "U"
BaseChars(31) = "V"
BaseChars(32) = "W"
BaseChars(33) = "X"
BaseChars(34) = "Y"
BaseChars(35) = "Z"


'Check base is within range
If BaseNo < 2 Or BaseNo > 36 Then
    Base_Error = "The base is out of range 2-36."
    Exit Function
End If

'Check the number contains no invalid characters
If Not CorrectBase(Trim$(Str$(number)), 10) Then
    Base_Error = "The number is not stored in the correct base."
    Exit Function
End If


'Determine column at which to start

Power = -1
Do
    Power = Power + 1
Loop Until (BaseNo ^ Power) > number
Power = Power - 1


AmountLeft = number
                     
For c1 = Power To 0 Step -1
    temp = Int(AmountLeft / (BaseNo ^ c1))
    If temp = BaseNo Then
        Result = Result + BaseChars(0)
    Else
        Result = Result + BaseChars(temp)
    End If
    AmountLeft = AmountLeft - (temp * (BaseNo ^ c1))
Next c1

If Result = "" Then Result = BaseChars(0)
DecimalToBase_NoPoint = Result
Base_Error = ""

Exit Function   'should exit here


DecimalToBase_NoPoint_Error:
Base_Error = Error$(Err)
Exit Function
Resume

End Function

Function DecimalToBase_Point (number As Double, BaseNo As Integer) As String

'This function is designed not to be used by
'the programmer, only internally by the functions.

'It handles converting numbers stored in decimal to a non-decimal base.

'It does not give as high a level of accuracy for large numbers as
'DecimalToBase_NoPoint, but supports real numbers as opposed to integers.

'Although this function can be called directly by the programmer,
'calling the function DecimalToBase instead will automatically
'decide which of the two functions is the most efficient for the
'number that has been passed as a parameter.

'The syntax for this function is the same as for DecimalToBase.


On Error GoTo DecimalToBase_Point_Error

Static BaseChars(0 To 35) As String
Dim AmountLeft, Power, count1, temp As Integer
Dim Result As String

Erase BaseChars

'Define Base characters
BaseChars(0) = "0"
BaseChars(1) = "1"
BaseChars(2) = "2"
BaseChars(3) = "3"
BaseChars(4) = "4"
BaseChars(5) = "5"
BaseChars(6) = "6"
BaseChars(7) = "7"
BaseChars(8) = "8"
BaseChars(9) = "9"
BaseChars(10) = "A"
BaseChars(11) = "B"
BaseChars(12) = "C"
BaseChars(13) = "D"
BaseChars(14) = "E"
BaseChars(15) = "F"
BaseChars(16) = "G"
BaseChars(17) = "H"
BaseChars(18) = "I"
BaseChars(19) = "J"
BaseChars(20) = "K"
BaseChars(21) = "L"
BaseChars(22) = "M"
BaseChars(23) = "N"
BaseChars(24) = "O"
BaseChars(25) = "P"
BaseChars(26) = "Q"
BaseChars(27) = "R"
BaseChars(28) = "S"
BaseChars(29) = "T"
BaseChars(30) = "U"
BaseChars(31) = "V"
BaseChars(32) = "W"
BaseChars(33) = "X"
BaseChars(34) = "Y"
BaseChars(35) = "Z"


'Check base is within range
If BaseNo < 2 Or BaseNo > 36 Then
    Base_Error = "The base is out of range 2-36."
    Exit Function
End If


'Check the number to convert is not negative
If number < 0 Then
    Base_Error = "The number to convert must not be negative."
    Exit Function
End If

'Determine column at which to start

Power = -1
Do
    Power = Power + 1
Loop Until (BaseNo ^ Power) > number


AmountLeft = number
                     
Do
    Power = Power - 1
    If Power = -1 Then Result = Result + "."
    temp = Int(AmountLeft / (BaseNo ^ Power))
    If temp = BaseNo Then
        Result = Result + BaseChars(0)
    Else
        Result = Result + BaseChars(temp)
    End If
    AmountLeft = AmountLeft - (temp * (BaseNo ^ Power))

Loop Until AmountLeft = 0

'check for 0's on the right
Do While Power > 0
    Result = Result + "0"
    Power = Power - 1
Loop

If Result = "" Then Result = BaseChars(0)
DecimalToBase_Point = Result
Base_Error = ""

Exit Function


DecimalToBase_Point_Error:
Base_Error = Error$(Err)
Exit Function
Resume

End Function

Function FullNumber (number)

'This function is designed not to be used by
'the programmer, only internally by the functions.

'It converts a number stored in an exponent form
'into it's full form and returns a variant.

Dim Result As String

Result = Format$(number, "#############################################################################################################0.####################################################################################################")

If Right$(Result, 1) = "." Then Result = Left$(Result, Len(Result) - 1)

FullNumber = Result
              
End Function

Function RoundNumber (number As String, BaseNo As Integer, Places As Integer) As String

'Rounds a number with digits and/or letters to the right
'of the point (in other words, not integers) to
'the number of  places specified in the variable
'Places. This is the same as rounding to a number of
'decimal places in base 10.

'If you specify more places than are available in the
'number, 0's will be placed at the right of the number.

'For example, rounding 1.47 to 3 places would produce
'1.470



'SYNTAX for use:
'
'RoundNumber (Number, BaseNo, Places)
'
'Where: Number is a string. If you are giving a value rather than
'            referring to a string-type variable, enclose the value in "".
'       BaseNo is an integer from 2 to 36, holding the base that Number is
'            stored in.
'       Places is an integer (0 or higher) showing how many places the
'           number should be rounded to.

'       The result of the function is returned as type string.

Dim count, count2, count3, boundary, NeedsMoreRounding, temp As Integer

Static BaseChars(0 To 35) As String

On Error GoTo RoundNumber_Error

Erase BaseChars

'Define Base characters
BaseChars(0) = "0"
BaseChars(1) = "1"
BaseChars(2) = "2"
BaseChars(3) = "3"
BaseChars(4) = "4"
BaseChars(5) = "5"
BaseChars(6) = "6"
BaseChars(7) = "7"
BaseChars(8) = "8"
BaseChars(9) = "9"
BaseChars(10) = "A"
BaseChars(11) = "B"
BaseChars(12) = "C"
BaseChars(13) = "D"
BaseChars(14) = "E"
BaseChars(15) = "F"
BaseChars(16) = "G"
BaseChars(17) = "H"
BaseChars(18) = "I"
BaseChars(19) = "J"
BaseChars(20) = "K"
BaseChars(21) = "L"
BaseChars(22) = "M"
BaseChars(23) = "N"
BaseChars(24) = "O"
BaseChars(25) = "P"
BaseChars(26) = "Q"
BaseChars(27) = "R"
BaseChars(28) = "S"
BaseChars(29) = "T"
BaseChars(30) = "U"
BaseChars(31) = "V"
BaseChars(32) = "W"
BaseChars(33) = "X"
BaseChars(34) = "Y"
BaseChars(35) = "Z"



'Check base is within range
If BaseNo < 2 Or BaseNo > 36 Then
    Base_Error = "The base is out of range 2-36."
    Exit Function
End If


'Check the number is stored in the correct base
If Not CorrectBase(number, BaseNo) Then
    Base_Error = "The number is not stored in the correct base."
    Exit Function
End If


'Error check on number of places
If Places < 0 Then
    Base_Error = "You must round off to 0 or higher places."
    Exit Function
End If

'Check there are numbers to the right of a point. Remove the point if not
If Right$(number, 1) = "." Then number = Left$(number, Len(number) - 1)


'Check that there is a decimal point. If there isn't,
'simply put 0's to the right of the point if needed and exit.

If InStr(number, ".") = 0 Then
    If Places > 0 Then
        number = number + "."
        For count = 1 To Places
            number = number + BaseChars(0)
        Next count
        If Right$(number, 1) = "." Then number = Left$(number, Len(number) - 1)
        RoundNumber = number
        Base_Error = ""
        Exit Function
    Else
        If Right$(number, 1) = "." Then number = Left$(number, Len(number) - 1)
        RoundNumber = number
        Base_Error = ""
        Exit Function
    End If
End If

'If the number of places in the number is smaller than
'the number of places passed as a parameter, add 0's and
'exit

If (Len(number) - InStr(number, ".")) <= Places Then
    For count = (Len(number) - InStr(number, ".")) To (Places - 1)
        number = number + BaseChars(0)
    Next count
    If Right$(number, 1) = "." Then number = Left$(number, Len(number) - 1)
    RoundNumber = number
    Exit Function
End If


'If the program gets to here, actual rounding is needed.

'Calculate the boundary digit, that separates the boundary
'between rounding up and down. For example, in decimal
'this is 5. Numbers at or higher than the boundary are
'rounded up.

'How the boundary is calculated:

'In bases with even numbers, such as 8, 10 and 16, the
'base number is halved, producing boundaries of 4, 5 and 8.

'In bases with odd numbers, such as 3,5,7, etc, a half way
'boundary would produce 1.5, 2.5 and 3.5 respectively.
'This function rounds these numbers up to 2, 3 and 4.
'To round down to 1, 2 and 3 remove the + .5 from the line
'below.

boundary = Int((BaseNo / 2) + .5)


'Cut off any numbers to the right of the new number
'produced after rounding. Keep one extra place for the
'moment so we know whether what will become the last digit
'has to be rounded.

number = Left$(number, InStr(number, ".") + Places + 1)




'Check the right hand digit to see if it is on or above the boundary

NeedsMoreRounding = False
For count = boundary To BaseNo - 1
    If BaseChars(count) = Mid$(number, Len(number), 1) Then
        NeedsMoreRounding = True
        Exit For
    End If
Next count

If NeedsMoreRounding Then
        'The number needs rounding up
        For count2 = Len(number) - 1 To 1 Step -1
        If Mid$(number, count2, 1) <> BaseChars(BaseNo - 1) Then
            'Find the character and add 1 to it
            For count3 = 0 To (BaseNo - 1)
                If Mid$(number, count2, 1) = BaseChars(count3) Then
                    Mid$(number, count2, 1) = BaseChars(count3 + 1)
                    NeedsMoreRounding = False
                    Exit For
                End If
            Next count3
        Else
            'Set the character to 0
            Mid$(number, count2, 1) = BaseChars(0)
            NeedsMoreRounding = True
        End If
    If Not NeedsMoreRounding Then Exit For
    Next count2
End If

                             

If count2 = 0 And NeedsMoreRounding Then number = BaseChars(1) + number


'Remove the far right digit, which we used to check if
'any rounding was needed

number = Left$(number, Len(number) - 1)

'Assign the result to the fuction name

If Right$(number, 1) = "." Then number = Left$(number, Len(number) - 1)
RoundNumber = number
Base_Error = ""

Exit Function'Should exit here

RoundNumber_Error:
Base_Error = Error$(Err)
Exit Function
Resume


End Function

